//
//  ItemsViewController.m
//  PIT
//
//  Created by VA DEVELOPER on 11/24/12.
//  Copyright (c) 2012 . All rights reserved.
//

#import "ItemsViewController.h"
#import "PITItemStore.h"
#import "PITItem.h"

@implementation ItemsViewController
@synthesize backupData, ssl;

- (id) init {
    self = [super initWithStyle:UITableViewStyleGrouped];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(didEnterBackground:) name:@"didEnterBackground"
                                                   object:nil];
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(didBecomeActive:) name:@"didBecomeActive"
                                                   object:nil];
        
        
        for (int i = 0; i < 5; i++) {
            UINavigationItem *n = [self navigationItem];
            [n setTitle:@"Add a Veteran"];
        
            
            UIBarButtonItem *bbi = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAdd target:self action:@selector(addNewItem:)];
            [[self navigationItem] setRightBarButtonItem:bbi];
            
            [[self navigationItem] setLeftBarButtonItem:[self editButtonItem]];
        }
    }
    return self;
}

- (id) initWithStyle:(UITableViewStyle) style {
    
    return [self init];
}


- (void)didEnterBackground:(NSNotification *)notification
{
    NSLog(@"Oh Snap! User went home! (IVC)");
    self.tableView.hidden = YES;
    
}

- (void)didBecomeActive:(NSNotification *)notification
{
    NSLog(@"Oh Snap! User came back! (IVC)");
    self.tableView.hidden = NO;
}

- (void) viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    BOOL success = [[PITItemStore sharedStore] saveChanges];
    if(success) {
        NSLog(@"ItemViewController: Archiving all items.");
    } else {
        NSLog(@"ItemViewController: WARNING!! Could NOT archive!!");
    }
    
    [[self tableView] reloadData];
    
//    if (webServiceListening()) {
//        [backupData setEnabled:YES];
//        [backupData setAlpha:1.0];
//    } else {
//        [backupData setEnabled:NO];
//        [backupData setAlpha:0.5];
//    }
    //vadim commented out on 1/17/13 because this would hang UI if the web server was unreachable.
}

- (NSInteger) tableView: (UITableView *) tableView numberOfRowsInSection:(NSInteger)section {
    return [[[PITItemStore sharedStore] allItems] count];
}

- (UITableViewCell *) tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"UITableViewCell"];
    
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"UITableViewCell"];
    }
    
    PITItem *p = [[[PITItemStore sharedStore] allItems] objectAtIndex:[indexPath row]];
    
    [[cell textLabel] setText:[p description]];
    
    return cell;
}

- (void) tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        PITItemStore *ps = [PITItemStore sharedStore];
        NSArray *items = [ps allItems];
        PITItem *p = [items objectAtIndex:[indexPath row]];
        [ps removeItem:p];
        
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }
}

// Implemented for header view


- (void) tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)sourceIndexPath toIndexPath:(NSIndexPath *)destinationIndexPath {
    [[PITItemStore sharedStore] moveItemAtIndex:[sourceIndexPath row] toIndex: [destinationIndexPath row]];
}

- (void) tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    DetailViewController *detailViewController = [[DetailViewController alloc] init];
    
    
    NSArray *items = [[PITItemStore sharedStore] allItems];
    PITItem *selectedItem = [items objectAtIndex: [indexPath row]];
    [detailViewController setItem:selectedItem];
    
    
    [[self navigationController] pushViewController:detailViewController animated:YES];
}

- (IBAction) addNewItem:(id)sender {
    //    int lastRow = [[[PITItemStore sharedStore] allItems] indexOfObject:newItem];
    PITItem *newItem = [[PITItemStore sharedStore] createItem];

    DetailViewController *detailViewController = [[DetailViewController alloc] init];
    
    [detailViewController setItem:newItem];
    
    [[self navigationController] pushViewController:detailViewController animated:YES];

    
    //NSIndexPath *ip = [NSIndexPath indexPathForRow:lastRow inSection:0];
    //[[self tableView] insertRowsAtIndexPaths:[NSArray arrayWithObject:ip] withRowAnimation:UITableViewRowAnimationTop];
}

- (bool) webServiceListening {
    //check if web service is listening
//    NSURLResponse *response;
//    NSError *error;
//    NSString *sUrl = @"http://vhaisfapp1.vha.DOMAIN.EXT:7002/Homeless-PIT-Web/veteran/hello";
//    NSString *sUrl = @"https://staff.mobilehealth.DOMAIN.EXT/Homeless-PIT-Web/svc/veteran/hello";
//    NSString *sUrl = @"https://127.0.0.1/Homeless-PIT-Web/svc/veteran/hello";
    NSString *sUrl = [NSString stringWithFormat:@"%@hello", [[NSBundle mainBundle] objectForInfoDictionaryKey:@"PITWebServiceUrl"]];
    [self connect:sUrl];
    return NO;

}

-(void) connect:(NSString*)url {
    NSMutableString* urlString = [NSMutableString stringWithCapacity:128];
    [urlString appendString:url];
    NSLog(@"URL[%@]", urlString);
    finished = NO;
    [NSURLConnection connectionWithRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:urlString]] delegate: self];
    NSRunLoop* loop = [NSRunLoop currentRunLoop];
    while (finished == NO && [loop runMode:NSDefaultRunLoopMode beforeDate:[NSDate distantFuture] ]);
}

- (void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response {
    NSLog(@"000>%@", [response description]);
}

- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data {
    NSString *response = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
    NSLog(@"--->: %@", response);
    if ([response isEqualToString:@"\"hello\""]) {
        NSLog(@"Web Service is listening");
        webServiceRunning = YES;
    }
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection {
    finished = YES;
}

- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error {
    finished = YES;
    NSLog(@"err->%@", error);
}

- (void)connection:(NSURLConnection *)connection willSendRequestForAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge {
    NSURLProtectionSpace * protectionSpace = [challenge protectionSpace];
    NSURLCredential* credentail = [NSURLCredential credentialForTrust:[protectionSpace serverTrust]];
    [[challenge sender] useCredential:credentail forAuthenticationChallenge:challenge];
}

- (UIView *) backupView {
    /** POTENTIAL BACKUP CODE
    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"] length] > 7) {
        if (!backupView) {
            [[NSBundle mainBundle] loadNibNamed:@"BackupView" owner:self options:nil];
        }
        return backupView;
    }
    */
    
//    return nil;
    if (!backupView) {
        [[NSBundle mainBundle] loadNibNamed:@"BackupView" owner:self options:nil];
        [backupData setTitle:@"Upload Data (disabled)" forState:UIControlStateDisabled];
    }
    return backupView;
}

- (IBAction) backupData: (id) sender {
    
    /** POTENTIAL BACKUP CODE
    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"] length] > 7) {
        NSLog(@"Backing up data.");
        BOOL success = [[PITItemStore sharedStore] backupChanges];
        if(success) {
            NSLog(@"ItemViewController: Backing up Archive.");
        } else {
            NSLog(@"ItemViewController: WARNING!! Could NOT back up!!");
        }
    }
    */
    
    NSString *btnTitle = [backupData currentTitle];
    [sender setEnabled:NO];
    [sender setTitle:@"Uploading..." forState:UIControlStateNormal];
    
    //take a breather and let queued up UI messages a chance to get processed
    NSDate *dtr = [[NSDate alloc] initWithTimeIntervalSinceNow:0.3];
    [[NSRunLoop currentRunLoop] runMode:NSDefaultRunLoopMode beforeDate:dtr];
    
//    if (webServiceListening()) {
    webServiceRunning = NO;
    [self webServiceListening];
    if (webServiceRunning) {
        [[PITItemStore sharedStore] backupChanges];
        
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Upload Result"
                                                        message:@"Server is not available at this time.\nPlease try again later."
                                                       delegate:nil
                                              cancelButtonTitle:@"OK"
                                              otherButtonTitles:nil];
        [alert show];
    }
    [sender setEnabled:YES];
    [sender setTitle:btnTitle forState:UIControlStateNormal];
}

- (UIView *) tableView: (UITableView *) tv viewForHeaderInSection:(NSInteger) sec {
    /** POTENTIAL BACKUP CODE
    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"] length] > 7) {
        return [self backupView];
    }
    */
//    return nil;
    return [self backupView];

}

- (CGFloat) tableView: (UITableView *) tv heightForHeaderInSection:(NSInteger) sec {
    /** POTENTIAL BACKUP CODE
    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"] length] > 7) {
        return [[self backupView] bounds].size.height;
    }
     */
//    return 0;
    return [[self backupView] bounds].size.height;

}

@end
